﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Unitronics.ComDriver;
using Unitronics.ComDriver.Messages.DataRequest;
using System.Runtime.Remoting.Messaging;
using System.Reflection;

namespace Com_Drive_Net___Example
{
    public partial class Form1 : Form
    {
        PLC plc;
        const int LOCAL_PORT = 100;
        delegate void SetControlValueCallback(Control oControl, string propName, object propValue);

        public Form1()
        {
            InitializeComponent();
            setButtonsEnableState(false);
        }

        private void setButtonsEnableState(bool value)
        {
            MethodInvoker mi = delegate()
            {
                Connect.Enabled = !value;
                Reset.Enabled = value;
                Init.Enabled = value;
                Stop.Enabled = value;
                Run.Enabled = value;
                Read.Enabled = value;
                ReadAsynch.Enabled = value;
                Write.Enabled = value;
            };
            UpdateUI(mi);
        }

        private void Connect_Click(object sender, EventArgs e)
        {
            EthernetListener listener = PLCFactory.GetChannel(LOCAL_PORT);
            if (listener == null)
                listener = new EthernetListener(LOCAL_PORT, 3, 3000);

            listener.OnListenerConnectionAccepted += new EthernetListener.ListenerConnectionAcceptedDelegate(OnConnect);
            listener.OnListenerConnectionClosed += new EthernetListener.ListenerConnectionClosedDelegate(OnDisconnect);
            PLCFactory.GetPLC(listener);
        }

        private void OnConnect(PLC oPlc)
        {
            plc = oPlc;
            setButtonsEnableState(true);
            PlcVersion version = plc.Version;
            MethodInvoker mi = delegate()
            {
                txtModel.Text = version.OPLCModel;
                txtHW.Text = version.HWVersion;
                txtOS.Text = version.OSVersion;
                txtBoot.Text = version.Boot;
                txtBinLib.Text = version.BinLib;
                txtFactoryBoot.Text = version.FactoryBoot;

                try
                {
                    string plcName = plc.PlcName;
                    txtPlcName.Text = plcName;
                }
                catch
                {
                }
            };
            UpdateUI(mi);        
        }

        private void OnDisconnect(EthernetListener ethernetListener)
        {
            setButtonsEnableState(false);
            MethodInvoker mi = delegate()
            {
                txtModel.Text = "";
                txtHW.Text = "";
                txtOS.Text = "";
                txtBoot.Text = "";
                txtBinLib.Text = "";
                txtFactoryBoot.Text = "";
                txtPlcName.Text = "";
            };
            UpdateUI(mi);  

            if (plc != null)
            {
                if (plc.PLCChannel == ethernetListener)
                {
                    System.Diagnostics.Debug.Print("The Ethernet Listener of out PLC object was closed. It is not longer connected");
                }
            }
        }


        private void Reset_Click(object sender, EventArgs e)
        {
            try
            {
                plc.Reset();
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC");
            }
        }

        private void Init_Click(object sender, EventArgs e)
        {
            try
            {
                plc.Init();
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC");
            }
        }

        private void Stop_Click(object sender, EventArgs e)
        {
            try
            {
                plc.Stop();
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC");
            }
        }

        private void Run_Click(object sender, EventArgs e)
        {
            try
            {
                plc.Run();
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC");
            }
        }

        private void Disconnect_Click(object sender, EventArgs e)
        {
            EthernetListener listener = PLCFactory.GetChannel(LOCAL_PORT);

            if (plc != null)
            {
                plc.Disconnect();
            }
            else
            {
                if (listener != null)
                    listener.Disconnect();
            }

            setButtonsEnableState(false);
            txtModel.Text = "";
            txtHW.Text = "";
            txtOS.Text = "";
            txtBoot.Text = "";
            txtBinLib.Text = "";
            txtFactoryBoot.Text = "";

            listener.OnListenerConnectionAccepted -= new EthernetListener.ListenerConnectionAcceptedDelegate(OnConnect);
            listener.OnListenerConnectionClosed -= new EthernetListener.ListenerConnectionClosedDelegate(OnDisconnect);
        }

        private void Read_Click(object sender, EventArgs e)
        {
            ReadWriteRequest[] rw = new ReadWriteRequest[1];

            rw[0] = new ReadOperands()
            {
                OperandType = OperandTypes.MI,
                NumberOfOperands = 3,
                StartAddress = 0
            };

            try
            {
                plc.ReadWrite(ref rw);
                
                object[] values = (object[])(rw[0].ResponseValues);
                
                for (int i=0; i<values.Length; i++)
                {
                    if (values[i] != null)
                    {
                        TextBox txtbox = this.groupBox1.Controls["txtMI" + i.ToString()] as TextBox;
                        txtbox.Text = ((short)values[i]).ToString();
                    }
                }
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC");
            }
        }

        private void Write_Click(object sender, EventArgs e)
        {
            object[] values = new object[3];
            try
            {
                values[0] = (object)Convert.ToInt16(txtMI0.Text);
                values[1] = (object)Convert.ToInt16(txtMI1.Text);
                values[2] = (object)Convert.ToInt16(txtMI2.Text);
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("One of more of the values are not valid");
                return;
            }

            ReadWriteRequest[] rw = new ReadWriteRequest[1];

            rw[0] = new WriteOperands()
            {
                OperandType = OperandTypes.MI,
                NumberOfOperands = 3,
                StartAddress = 0,
                Values = values
            };


            try
            {
                plc.ReadWrite(ref rw);
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC");
            }
        }

        private void ReadAsynch_Click(object sender, EventArgs e)
        {
            ReadWriteRequest[] rw = new ReadWriteRequest[1];

            rw[0] = new ReadOperands()
            {
                OperandType = OperandTypes.MI,
                NumberOfOperands = 3,
                StartAddress = 0
            };

            try
            {
                plc.ReadWrite(ref rw, AsyncReply);
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC");
            }
        }

        private void AsyncReply(IAsyncResult ar)
        {
            AsyncResult async;
            async = (AsyncResult)ar;
            ReadWriteOperandsDelegate del = (ReadWriteOperandsDelegate)async.AsyncDelegate;
            ReadWriteRequest[] rw = new ReadWriteRequest[0];

            try
            {
                del.EndInvoke(ref rw, ar);
            }
            catch (Exception ex)
            {
                System.Windows.Forms.MessageBox.Show(ex.Message);
                return;
            }

            object[] values = (object[])(rw[0].ResponseValues);

            MethodInvoker mi = delegate()
            {
                for (int i = 0; i < values.Length; i++)
                {
                    if (values[i] != null)
                    {
                        TextBox txtbox = this.groupBox1.Controls["txtMI" + i.ToString()] as TextBox;
                        txtbox.Text = Convert.ToInt16(values[i]).ToString();
                    }
                }
            };
            UpdateUI(mi);
        }

        private void UpdateUI(MethodInvoker del)
        {
            if (this.InvokeRequired)
                this.Invoke(del);
            else
                del();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            EthernetListener listener = PLCFactory.GetChannel(LOCAL_PORT);
            if (listener != null)
                lblStatus.Text = listener.Status.ToString();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (plc != null)
            {
                plc.Disconnect();
            }
            else
            {
                EthernetListener listener = PLCFactory.GetChannel(LOCAL_PORT);
                if (listener != null)
                    listener.Disconnect();
            }
        }
    }
}
